/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.messaging;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.entities.factories.PlantEntityAttributesFactory;
import technology.rocketjump.undermount.entities.factories.PlantEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapgen.generators.ShrubPlanter;
import technology.rocketjump.undermount.mapgen.generators.TreePlanter;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.mapping.tile.TileRoof;
import technology.rocketjump.undermount.messaging.types.PlantSeedDispersedMessage;

@Singleton
public class PlantMessageHandler
implements GameContextAware,
Telegraph,
Disposable {
    private static final int MAX_NEIGHBOUR_SHRUBS_ALLOWED = 2;
    private final MessageDispatcher messageDispatcher;
    private final PlantEntityAttributesFactory plantEntityAttributesFactory;
    private final PlantEntityFactory plantEntityFactory;
    private final TreePlanter treePlanter = new TreePlanter();
    private final ShrubPlanter shrubPlanter = new ShrubPlanter();
    private GameContext gameContext;

    @Inject
    public PlantMessageHandler(MessageDispatcher messageDispatcher, PlantEntityAttributesFactory plantEntityAttributesFactory, PlantEntityFactory plantEntityFactory) {
        this.messageDispatcher = messageDispatcher;
        this.plantEntityAttributesFactory = plantEntityAttributesFactory;
        this.plantEntityFactory = plantEntityFactory;
        messageDispatcher.addListener(this, 320);
        messageDispatcher.addListener(this, 321);
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 320);
        this.messageDispatcher.removeListener((Telegraph)this, 321);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 320: {
                PlantSeedDispersedMessage entityMessage = (PlantSeedDispersedMessage)msg.extraInfo;
                this.handle(entityMessage, true);
                return true;
            }
            case 321: {
                PlantSeedDispersedMessage entityMessage = (PlantSeedDispersedMessage)msg.extraInfo;
                this.handle(entityMessage, false);
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private void handle(PlantSeedDispersedMessage message, boolean isFruit) {
        PlantSpeciesType plantType = message.getPlantSpecies().getPlantType();
        int numAttempts = plantType.equals((Object)PlantSpeciesType.TREE) ? 5 : 3;
        int numToCreate = isFruit ? 2 : 1;
        int created = 0;
        int attempted = 0;
        MapTile sourceTile = this.gameContext.getAreaMap().getTile(message.getOrigin());
        if (sourceTile == null) {
            System.err.println("Source tile for handling message is null in " + this.getClass().getName());
            return;
        }
        GridPoint2 sourcePoint = new GridPoint2(sourceTile.getTileX(), sourceTile.getTileY());
        while (created < numToCreate && attempted < numAttempts) {
            ++attempted;
            GridPoint2 nearbyPosition = plantType.equals((Object)PlantSpeciesType.TREE) ? this.treePlanter.randomPointNear(sourcePoint, this.gameContext.getRandom()) : this.shrubPlanter.randomPointNear(sourcePoint, this.gameContext.getRandom());
            MapTile nearbyTile = this.gameContext.getAreaMap().getTile(nearbyPosition.x, nearbyPosition.y);
            boolean isAllowedToSpawn = plantType.equals((Object)PlantSpeciesType.TREE) ? this.isTreeAllowedAt(nearbyTile) : this.isShrubAllowedAt(nearbyTile);
            if (!isAllowedToSpawn) continue;
            this.createPlant(message.getPlantSpecies(), nearbyPosition);
            ++created;
        }
    }

    private boolean isShrubAllowedAt(MapTile targetTile) {
        if (!(targetTile != null && targetTile.getFloor() != null && targetTile.getRoof() != null && targetTile.getFloor().getMaterial() != null && targetTile.getRoof().equals((Object)TileRoof.OPEN) && targetTile.isEmpty() && targetTile.getFloor().getMaterial().getMaterialName().equals("grass"))) {
            return false;
        }
        TileNeighbours tileNeighbours = this.gameContext.getAreaMap().getNeighbours(targetTile.getTileX(), targetTile.getTileY());
        int numNeighbourShrubs = 0;
        for (MapTile mapTile : tileNeighbours.values()) {
            if (!mapTile.hasShrub()) continue;
            ++numNeighbourShrubs;
        }
        return numNeighbourShrubs <= 2;
    }

    private boolean isTreeAllowedAt(MapTile targetTile) {
        if (!(targetTile != null && targetTile.getRoof().equals((Object)TileRoof.OPEN) && targetTile.isEmpty() && targetTile.getFloor().getMaterial().getMaterialName().equals("grass"))) {
            return false;
        }
        for (MapTile neighbourTile : this.gameContext.getAreaMap().getNeighbours(targetTile.getTileX(), targetTile.getTileY()).values()) {
            if (!neighbourTile.hasWall() && !neighbourTile.hasTree()) continue;
            return false;
        }
        return true;
    }

    private void createPlant(PlantSpecies plantSpecies, GridPoint2 targetTile) {
        PlantEntityAttributes attributes = this.plantEntityAttributesFactory.newPlantBySpecies(plantSpecies, this.gameContext.getRandom());
        Entity newEntity = this.plantEntityFactory.create(attributes, targetTile, this.gameContext.getAreaMap());
        this.gameContext.getEntityStore().add(newEntity, this.gameContext.getAreaMap());
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

